/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.security;

import de.willuhn.jameica.security.Certificate;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.JameicaException;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public class JameicaHostnameVerifier
implements HostnameVerifier {
    private HostnameVerifier parent = null;

    public JameicaHostnameVerifier(HostnameVerifier parent) {
        this.parent = parent;
    }

    @Override
    public boolean verify(String hostname, SSLSession session) {
        java.security.cert.Certificate[] certs = new java.security.cert.Certificate[]{};
        try {
            certs = session.getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException e) {
            Logger.error((String)"error while reading certificates from session", (Throwable)e);
            throw new JameicaException(Application.getI18n().tr("Server-Zertifikate k\u00f6nnen nicht ermittelt werden"));
        }
        boolean match = false;
        for (int i = 0; i < certs.length; ++i) {
            Certificate c = new Certificate(certs[i]);
            List<String> hostnames = c.getHostnames();
            if (hostnames == null || hostnames.isEmpty()) continue;
            for (String h : hostnames) {
                Logger.debug((String)("comparing hostname " + hostname + " (from server) with " + h + " (from certificate)"));
                if (!h.equalsIgnoreCase(hostname)) continue;
                Logger.debug((String)"hostname matched");
                match = true;
                break;
            }
            if (match) break;
        }
        if (!match) {
            try {
                return Application.getCallback().checkHostname(hostname, session.getPeerCertificateChain());
            }
            catch (OperationCanceledException oce) {
                throw oce;
            }
            catch (Exception e) {
                Logger.error((String)"error while asking user something", (Throwable)e);
            }
        }
        if (this.parent != null) {
            return this.parent.verify(hostname, session);
        }
        throw new JameicaException(Application.getI18n().tr("Server-Zertifikat kann nicht gepr\u00fcft werden"));
    }
}

